/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.rep.RAssoKey;
import com.ibm.hsc.rep.RAssoSchema;
import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v40.R40Define;
import com.ibm.hsc.rep.v40.R40SchemaDefine;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50SchemaDefine;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;

public class RUtils {
    public static final String IBMHSC_NAME_SPACE_V4_0 = "root/ibmhscV3_2";
    public static final String IBMHSC_NAME_SPACE_V5_0 = "root/ibmhscS1_0";
    public static final int NSID_IBMHSC_NAME_SPACE_V4_0 = 0;
    public static final int NSID_IBMHSC_NAME_SPACE_V5_0 = 1;
    public static final int ENUM_DT_SINGLE_FIRST = 1;
    public static final int ENUM_DT_SINGLE_LAST = 14;
    public static final int ENUM_DT_ARRAY_BASE = 20;
    public static final int ENUM_DT_ARRAY_FIRST = 21;
    public static final int ENUM_DT_ARRAY_LAST = 34;

    private RUtils() {
    }

    public static int getNameSpaceId(String string) throws RException {
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return 0;
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return 1;
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static String getNameSpaceString(int n) throws RException {
        if (n == 0) {
            return IBMHSC_NAME_SPACE_V4_0;
        }
        if (n == 1) {
            return IBMHSC_NAME_SPACE_V5_0;
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static RClassSchema getClassSchema(int n, int n2) throws RException {
        switch (n) {
            case 0: {
                return R40SchemaDefine.getClassSchema(n2);
            }
            case 1: {
                return R50SchemaDefine.getClassSchema(n2);
            }
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static RClassSchema getClassSchema(String string, int n) throws RException {
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return R40SchemaDefine.getClassSchema(n);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return R50SchemaDefine.getClassSchema(n);
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static RAssoSchema getAssoSchema(int n, int n2) throws RException {
        switch (n) {
            case 0: {
                return R40SchemaDefine.getAssoSchema(n2);
            }
            case 1: {
                return R50SchemaDefine.getAssoSchema(n2);
            }
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static RAssoSchema getAssoSchema(String string, int n) throws RException {
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return R40SchemaDefine.getAssoSchema(n);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return R50SchemaDefine.getAssoSchema(n);
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static boolean hasClass(int n, String string) {
        String string2 = string.toLowerCase();
        switch (n) {
            case 0: {
                return R40Define.hmcClassHash.containsKey(string2);
            }
            case 1: {
                return R50Define.hmcClassHash.containsKey(string2);
            }
        }
        return false;
    }

    public static boolean hasClass(String string, String string2) {
        String string3 = string2.toLowerCase();
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return R40Define.hmcClassHash.containsKey(string3);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return R50Define.hmcClassHash.containsKey(string3);
        }
        return false;
    }

    public static int getClassId(int n, String string) throws RException {
        String string2 = string.toLowerCase();
        switch (n) {
            case 0: {
                return (Integer)R40Define.hmcClassHash.get(string2);
            }
            case 1: {
                return (Integer)R50Define.hmcClassHash.get(string2);
            }
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static int getClassId(String string, String string2) throws RException {
        String string3 = string2.toLowerCase();
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return (Integer)R40Define.hmcClassHash.get(string3);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return (Integer)R50Define.hmcClassHash.get(string3);
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static boolean hasAsso(int n, String string) {
        String string2 = string.toLowerCase();
        switch (n) {
            case 0: {
                return R40Define.hmcAssoHash.containsKey(string2);
            }
            case 1: {
                return R50Define.hmcAssoHash.containsKey(string2);
            }
        }
        return false;
    }

    public static boolean hasAsso(String string, String string2) {
        String string3 = string2.toLowerCase();
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return R40Define.hmcAssoHash.containsKey(string3);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return R50Define.hmcAssoHash.containsKey(string3);
        }
        return false;
    }

    public static int getAssoId(int n, String string) throws RException {
        String string2 = string.toLowerCase();
        switch (n) {
            case 0: {
                return (Integer)R40Define.hmcAssoHash.get(string2);
            }
            case 1: {
                return (Integer)R50Define.hmcAssoHash.get(string2);
            }
        }
        return -1;
    }

    public static int getAssoId(String string, String string2) throws RException {
        String string3 = string2.toLowerCase();
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            return (Integer)R40Define.hmcAssoHash.get(string3);
        }
        if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            return (Integer)R50Define.hmcAssoHash.get(string3);
        }
        throw new RException("R_ERR_NOT_SUPPORTED");
    }

    public static void dumpObjs(int n, int n2, PrintWriter printWriter) throws RException {
        Hashtable hashtable;
        RClassSchema rClassSchema;
        if (n == 0 || n == 1) {
            rClassSchema = RUtils.getClassSchema(n, n2);
            hashtable = rClassSchema.getObjHash();
            Enumeration enumeration = hashtable.elements();
            printWriter.println("########## " + rClassSchema.getClassName() + " instances ##########");
            printWriter.println();
            while (enumeration.hasMoreElements()) {
                RObject rObject = (RObject)enumeration.nextElement();
                printWriter.println(rObject);
            }
        } else {
            throw new RException("R_ERR_NOT_SUPPORTED");
        }
        printWriter.println("########## The number of " + rClassSchema.getClassName() + " instances is " + hashtable.size() + " ##########");
        printWriter.println();
    }

    public static void dumpAllObjs(int n, PrintWriter printWriter) throws RException {
        if (n == 0) {
            for (int i = 0; i < 11; ++i) {
                RUtils.dumpObjs(n, i, printWriter);
            }
        } else if (n == 1) {
            for (int i = 0; i < R50Define.NumOfClasses; ++i) {
                RUtils.dumpObjs(n, i, printWriter);
            }
        } else {
            throw new RException("R_ERR_NOT_SUPPORTED");
        }
    }

    public static void dumpAllObjs(String string, PrintWriter printWriter) throws RException {
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            int n = RUtils.getNameSpaceId(string);
            for (int i = 0; i < 11; ++i) {
                RUtils.dumpObjs(n, i, printWriter);
            }
        } else if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            int n = RUtils.getNameSpaceId(string);
            for (int i = 0; i < R50Define.NumOfClasses; ++i) {
                RUtils.dumpObjs(n, i, printWriter);
            }
        } else {
            throw new RException("R_ERR_NOT_SUPPORTED");
        }
    }

    public static void dumpAssos(int n, int n2, PrintWriter printWriter) throws RException {
        int n3;
        RAssoSchema rAssoSchema;
        if (n == 0 || n == 1) {
            rAssoSchema = RUtils.getAssoSchema(n, n2);
            String string = rAssoSchema.getRef1PropName();
            String string2 = rAssoSchema.getRef2PropName();
            int n4 = rAssoSchema.getRef1LinkId();
            RClassSchema rClassSchema = RUtils.getClassSchema(n, rAssoSchema.getRef1ClassId());
            printWriter.println("########## " + rAssoSchema.getClassName() + " ##########");
            printWriter.println();
            int n5 = rClassSchema.getLinkBase();
            Hashtable hashtable = rClassSchema.getObjHash();
            Enumeration enumeration = hashtable.elements();
            n3 = 0;
            while (enumeration.hasMoreElements()) {
                RObject rObject = (RObject)enumeration.nextElement();
                RObjectId rObjectId = rObject.getObjectId();
                Vector vector = rObject.enumLinks(n4);
                int n6 = 0;
                if (vector != null) {
                    n6 = vector.size();
                }
                for (int i = 0; i < n6; ++i) {
                    RObjectId rObjectId2 = (RObjectId)vector.elementAt(i);
                    printWriter.println("instance of " + rAssoSchema.getClassName() + " {");
                    printWriter.print(string + " = ");
                    printWriter.println(rObjectId);
                    printWriter.print(string2 + " = ");
                    printWriter.println(rObjectId2);
                    if (rAssoSchema.hasProperty()) {
                        Hashtable hashtable2 = rAssoSchema.getAssoPropHash();
                        Hashtable hashtable3 = RAssoSchema.getAssoObjHash();
                        RAssoKey rAssoKey = new RAssoKey(n, n2, rObjectId, rObjectId2);
                        Hashtable hashtable4 = (Hashtable)hashtable3.get(rAssoKey);
                        Enumeration enumeration2 = hashtable2.keys();
                        while (enumeration2.hasMoreElements()) {
                            String string3 = (String)enumeration2.nextElement();
                            printWriter.print(string3 + " = ");
                            Object var24_24 = null;
                            if (hashtable4 != null) {
                                var24_24 = hashtable4.get(string3);
                            }
                            printWriter.print((Object)var24_24);
                            printWriter.println(";");
                        }
                    }
                    printWriter.println("}");
                    printWriter.println();
                }
                n3 += n6;
            }
        } else {
            throw new RException("R_ERR_NOT_SUPPORTED");
        }
        printWriter.println();
        printWriter.println("########## The number of " + rAssoSchema.getClassName() + " instances is " + n3 + " ##########");
        printWriter.println();
    }

    public static void dumpAllAssos(String string, PrintWriter printWriter) throws RException {
        if (string.equals(IBMHSC_NAME_SPACE_V4_0)) {
            int n = RUtils.getNameSpaceId(string);
            for (int i = 0; i < 15; ++i) {
                RUtils.dumpAssos(n, i, printWriter);
            }
        } else if (string.equals(IBMHSC_NAME_SPACE_V5_0)) {
            int n = RUtils.getNameSpaceId(string);
            for (int i = 0; i < R50Define.NumOfAssos; ++i) {
                RUtils.dumpAssos(n, i, printWriter);
            }
        } else {
            throw new RException("R_ERR_NOT_SUPPORTED");
        }
    }

    public static Vector queryMatched(int n, int n2, int n3, Hashtable hashtable) throws RException {
        if (n != 0 && n != 1) {
            System.out.println("[TX-REP]RUtils.queryMatched: Wrong query type");
            return null;
        }
        RClassSchema rClassSchema = RUtils.getClassSchema(n2, n3);
        Hashtable hashtable2 = rClassSchema.getObjHash();
        Vector<Cloneable> vector = null;
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            RObjectId rObjectId = (RObjectId)enumeration.nextElement();
            RObject rObject = (RObject)hashtable2.get(rObjectId);
            boolean bl = true;
            if (hashtable != null) {
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    Object v = hashtable.get(string);
                    Object object = rObject.getProperty(string);
                    if (object != null && object.equals(v)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            if (vector == null) {
                vector = new Vector<Cloneable>();
            }
            if (n == 1) {
                vector.add(rObject);
                continue;
            }
            if (n != 0) continue;
            vector.add(rObjectId);
        }
        return vector;
    }

    public static Vector queryRefs(int n, int n2, int n3, RObjectId rObjectId) throws RException {
        if (n != 6 && n != 7 && n != 8 && n != 9) {
            System.out.println("[TX-REP]RUtils.queryRefs: Wrong query type: " + n);
            return null;
        }
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(n2, n3);
        RObject rObject = null;
        if (rObjectId != null) {
            rObject = rObjectId.getObject();
        }
        Vector vector = new Vector();
        if (rObject != null) {
            int n4 = -1;
            RClassSchema rClassSchema = rObject.getSchema();
            String string = rClassSchema.getClassName();
            if (rAssoSchema.getRef1ClassName().equalsIgnoreCase(string)) {
                n4 = rAssoSchema.getRef1LinkId();
            } else if (rAssoSchema.getRef2ClassName().equalsIgnoreCase(string)) {
                n4 = rAssoSchema.getRef2LinkId();
            }
            if (n4 != -1) {
                switch (n) {
                    case 7: {
                        vector = rObject.associatorsByLink(n4);
                        break;
                    }
                    case 6: {
                        vector = rObject.associatorNamesByLink(n4);
                        break;
                    }
                    case 8: 
                    case 9: {
                        vector = rObject.referencesByLink(n4);
                    }
                }
            }
        }
        return vector;
    }

    public static void validateDataType(CIMProperty cIMProperty) throws HSCCIMException {
        CIMDataType cIMDataType = cIMProperty.getType();
        CIMValue cIMValue = cIMProperty.getValue();
        Object object = null;
        if (cIMValue != null) {
            object = cIMValue.getValue();
        }
        if (object == null) {
            return;
        }
        String string = cIMProperty.getName();
        RUtils.validateDataType(cIMDataType, object, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validateDataType(CIMDataType cIMDataType, Object object, String string) {
        if (object == null) {
            return;
        }
        try {
            int n;
            int n2;
            block11: {
                block12: {
                    block10: {
                        n2 = cIMDataType.getType();
                        if (n2 < 1 || n2 > 14) break block10;
                        n = CIMDataType.findType((Object)object);
                        break block11;
                    }
                    if (n2 < 21 || n2 > 34) break block12;
                    if (object instanceof Vector) {
                        Object e;
                        Vector vector = (Vector)object;
                        n = 20;
                        if (vector.size() > 0 && (e = vector.elementAt(0)) != null) {
                            n = CIMDataType.findType(e) + 21 - 1;
                        }
                        break block11;
                    } else {
                        Class<?> clazz = object.getClass();
                        if (!clazz.isArray()) {
                            System.out.println("[TX-REP] propName=" + string + " requiredType=" + CIMDataType.getPredefinedType((int)n2) + " but propValue is not an array or a vector");
                            System.out.println("[TX-REP] type mismatch found.");
                            throw new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
                        }
                        Object[] objectArray = (Object[])object;
                        n = 20;
                        if (objectArray.length > 0 && objectArray[0] != null) {
                            n = CIMDataType.findType((Object)objectArray[0]) + 21 - 1;
                        }
                    }
                    break block11;
                }
                System.out.println("[TX-REP] type not supported.");
                throw new HSCCIMException("CIM_ERR_NOT_SUPPORTED");
            }
            if (n != 20) {
                if (n == n2) return;
                System.out.println("[TX-REP] type mismatch found.");
                System.out.println("[TX-REP] propName=" + string + " propValue=" + object + " propType=" + CIMDataType.getPredefinedType((int)n) + " requiredType=" + CIMDataType.getPredefinedType((int)n2));
                throw new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
            }
            if (n2 >= 21) {
                if (n2 <= 34) return;
            }
            System.out.println("[TX-REP] type mismatch found.");
            System.out.println("[TX-REP] propName=" + string + " does not expect array type");
            return;
        }
        catch (Throwable throwable) {
            System.out.println("[TX-REP] Error in RUtils.validateDataType: ");
            System.out.println("[TX-REP] propType=" + cIMDataType);
            System.out.println("[TX-REP] propValue=" + object);
            System.out.println("[TX-REP] propName=" + string);
            throwable.printStackTrace();
        }
    }
}

